<?php
namespace App\Http\Controllers;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\Pembayaran;
use App\Models\Kategori;
use App\Models\Pembelian;
use App\Models\Layanan;
use App\Models\User;
use App\Http\Controllers\VipResellerController;
use App\Http\Controllers\digiFlazzController;
use App\Http\Controllers\ApiGamesController;

class TokoPayController extends Controller
{
    protected $url = "https://api.tokopay.id/v1";

    public function __construct()
    {
        $api = \DB::table("setings")
            ->where("id", 1)
            ->first();
        $this->MerchantID = $api->tokopay_merchantid;
        $this->SecretKey = $api->tokopay_secretkey;
        $this->logoHeader = ENV("APP_LOGOFAVICON");
    }

    public function requestPay(
        $harga,
        $order_id,
        $nomor,
        $method,
        $email,
        $returnURL,
        $kodeProduk
    ) {
        $body = [
            "merchant_id" => $this->MerchantID,
            "kode_channel" => $method,
            "reff_id" => $order_id,
            "amount" => $harga,
            "customer_name" => ENV("APP_NAME"),
            "customer_email" => $email,
            "customer_phone" => $nomor,
            "redirect_url" => $returnURL,
            "expired_ts" => 0,
            "signature" => md5(
                $this->MerchantID . ":" . $this->SecretKey . ":" . $order_id
            ),
            "items" => [
                [
                    "product_code" => $kodeProduk,
                    "name" => "Pembayaran " . $method . " " . $order_id,
                    "price" => $harga,
                    "product_url" => "" . ENV("APP_URL") . "",
                    "image_url" =>
                        "" . ENV("APP_URL") . "/" . $this->logoHeader . "",
                ],
            ],
        ];
        $response = $this->connect("/order", $body);
        if ($response->status == "Success") {
            $data = $response->data;
            if (empty($data->ovo_push)) {
                if (empty($data->nomor_va)) {
                    if (empty($data->checkout_url)) {
                        $paymentNumber = $data->qr_link;
                    } else {
                        $paymentNumber = $data->checkout_url;
                    }
                } else {
                    $paymentNumber = $data->nomor_va;
                }
            } else {
                $paymentNumber = $data->ovo_push;
            }
            return [
                "success" => true,
                "amount" => $data->total_bayar,
                "no_pembayaran" => $paymentNumber,
                "reference" => $data->trx_id,
                "checkout_url" => $data->pay_url,
            ];
        } else {
            return ["success" => false, "msg" => $response->error_msg];
        }
    }

    public function checkaccount()
    {
        $body = [
            "merchant_id" => $this->MerchantID,
            "signature" => md5($this->MerchantID . $this->SecretKey),
        ];
        $response = $this->connect("/merchant", $body);
        if ($response->status == 1) {
            return [
                "success" => true,
                "nama_toko" => $response->data->nama_toko,
                "saldo_tersedia" => $response->data->saldo_tersedia,
                "saldo_tertahan" => $response->data->saldo_tertahan,
            ];
        } else {
            return ["success" => false, "msg" => $response->error_msg];
        }
    }

    public function withdraw($nominal)
    {
        $body = [
            "nominal" => $nominal,
            "merchant_id" => $this->MerchantID,
            "signature" => md5($this->MerchantID . $this->SecretKey),
        ];
        $response = $this->connect("/tarik-saldo", $body);
        if ($response->status == 1) {
            return ["success" => true, "msg" => $response->message];
        } else {
            return ["success" => false, "msg" => $response->error_msg];
        }
    }

    public function connect($endPoint, $body = [])
    {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $this->url . $endPoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($body),
            CURLOPT_HTTPHEADER => ["Content-Type: application/json"],
            CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
        ]);
        $response = json_decode(curl_exec($curl));
        curl_close($curl);
        return $response;
    }

    public function handle(Request $request)
    {
        $json = $request->getContent();
        $data = json_decode($json);
        try {
            Storage::disk("local")->put("callback-tokopay.txt", $json);
            if (isset($data->status, $data->reff_id, $data->signature)) {
                if ($data->status === "Success") {
                    // Hanya proses jika status transaksi sudah dibayar
                    $order_id = $data->reff_id;

                    // Validasi Signature
                    $signature_from_tokopay = $data->signature;
                    $signature_validasi = md5(
                        $this->MerchantID . ":" . $this->SecretKey . ":" . $order_id
                    );
                    if ($signature_from_tokopay === $signature_validasi) {
                        $pembayarans = Pembayaran::where("order_id", $order_id)
                            ->where("status", "Belum Lunas")
                            ->first();
                        if (!$pembayarans) {
                            Log::error("No invoice found or already paid: " . $order_id);
                            return Response::json([
                                "error" => "No invoice found or already paid: " . $order_id,
                            ])->setStatusCode(440);
                        } else {
                            // Proses pesanan setelah pembayaran terverifikasi
                            $dataPembeli = Pembelian::where("order_id", $order_id)->first();
                            $dataLayanan = Layanan::where("provider_id", $dataPembeli->kode_produk)->first();
                            $pembayaran = Pembayaran::where("order_id", $order_id)->first();
                            $dataKategori = Kategori::where("id", $dataLayanan->kategori_id)->first();
                            $zoneSend = $dataPembeli->zone == null ? "" : "($dataPembeli->zone)";
                            $nickname = $dataPembeli->nickname == null ? "" : "> Nickname : $dataPembeli->nickname\n";
                            $pesan = "Orderanmu dengan Invoice\n*$order_id* Telah Lunas dan sedang diproses mohon tunggu 1-10 Menit\n\n" .
                                "> Layanan : $dataPembeli->layanan\n" .
                                "> Data User : $dataPembeli->user_id $zoneSend\n" .
                                "> Nickname : $dataPembeli->nickname\n" .
                                "> Metode Pembayaran : $pembayaran->metode\n" .
                                "> Jumlah : Rp. " . number_format($pembayaran->harga + $pembayaran->fee, 0, ".", ",") .
                                "\n\n" .
                                "Invoice : " . env("APP_URL") . "/pembelian/invoice/$order_id\n\n";
                            $pesanAdmin = "Pembayaran $order_id Telah Lunas\n\n" .
                                "> Layanan : $dataPembeli->layanan\n" .
                                "> Data User : $dataPembeli->user_id $zoneSend\n" .
                                $nickname .
                                "> Metode Pembayaran : $pembayaran->metode\n" .
                                "> Jumlah : Rp. " . number_format($pembayaran->harga + $pembayaran->fee, 0, ".", ",") .
                                "\n\n" .
                                "*Kontak Pembeli*\n" .
                                "Whatsapp : wa.me/$pembayaran->no_pembeli\n" .
                                "Invoice : " . env("APP_URL") . "/pembelian/invoice/$order_id";

                            $updatePembayaran = $pembayaran->update([
                                "status" => "Lunas",
                            ]);

                            $requestPesan = $this->msg(ENV("NOMOR_ADMIN"), $pesanAdmin);
                            sleep(10);
                            $pesanMember = $this->msg($pembayaran->no_pembeli, $pesan);

                            Log::info("Processing order ID: " . $order_id);

                            // Proses pesanan berdasarkan provider
                            if ($dataLayanan->provider == "digiflazz") {
                                $digiFlazz = new digiFlazzController();
                                $order = $digiFlazz->order($dataPembeli->user_id, $dataPembeli->zone, $dataLayanan->provider_id, $order_id);
                                if ($order["data"]["status"] == "Gagal") {
                                    $order["data"]["status"] = false;
                                } else {
                                    $order["transactionId"] = $order_id;
                                    $keterangan = $order["data"]["sn"];
                                    $order["data"]["status"] = true;
                                }
                                return Response::json($order);
                            } else {
                                return Response::json([
                                    "success" => true,
                                    "msg" => "Pesanan telah diproses dan dikirim",
                                ]);
                            }
                        }
                    } else {
                        Log::error("Invalid Signature");
                        return Response::json([
                            "error" => "Invalid Signature",
                        ])->setStatusCode(410);
                    }
                } else {
                    Log::error("Status payment tidak success");
                    $pembayaran->update(["status" => "Batal"]);
                    return Response::json([
                        "error" => "Status payment tidak success",
                    ])->setStatusCode(420);
                }
            } else {
                Log::error("Data json tidak sesuai");
                return Response::json([
                    "error" => "Data json tidak sesuai",
                ])->setStatusCode(430);
            }
        } catch (\Exception $ex) {
            Log::error("Exception: " . $ex->getMessage());
            return Response::json([
                "error" => $ex->getMessage(),
            ])->setStatusCode(500);
        }
    }


    public function msg($number, $msg)
        {
            $api = \DB::table('setings')->where('id',1)->first();
            $data = [
                'api_key' => $api->captcha_secret,
                'sender'  => $api->captcha_sitekey,
                'number'  => "$number",
                'message' => "$msg"
            ];
            
             $curl = curl_init();
              curl_setopt_array($curl, [
              CURLOPT_URL => "https://wa.mikeneko.my.id/send-message",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "POST",
              CURLOPT_POSTFIELDS => json_encode($data),
              CURLOPT_HTTPHEADER => [
        "Accept: */*",
        "Content-Type: application/json",
      ],
    ]);
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    
    curl_close($curl);
        }
     
}